/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.fideicomiso.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresFideicomisos
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposFideicomisos = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.inicializado = true;
        }
    }

    public void cargarTiposFideicomiso(Periodo periodo) {
        this.tiposFideicomisos.clear();
        Map fideicomisos = UtilCatalogosATS.crearInstancia().obtenerFideicomisos(periodo.getFechaDeclarada());
        for (Map.Entry comp : fideicomisos.entrySet()) {
            this.tiposFideicomisos.put((String)comp.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)String.valueOf(comp.getKey())));
        }
    }

    public List<ElementoNombreValor<String>> getTiposFideicomiso() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposFideicomisos.values());
    }

    public ElementoNombreValor<String> obtenerTipoFideicomiso(String codigoFideicomiso) {
        return StringUtil.isNullOrEmpty((String)codigoFideicomiso) ? null : this.tiposFideicomisos.get(codigoFideicomiso);
    }
}

